#!/bin/bash

# called by dracut
check() {
    [[ $mount_needs ]] && return 1

    # If the binary(s) requirements are not fulfilled the module can't be installed
    require_binaries "$systemdutildir"/systemd || return 1

    return 0
}

# called by dracut
depends() {
    local deps
    deps="systemd-initrd systemd-ask-password"

    # when systemd and crypt are both included
    # systemd-cryptsetup is mandatory dependency
    # see https://github.com/dracut-ng/dracut-ng/issues/563
    if dracut_module_included "crypt"; then
        module_check systemd-cryptsetup > /dev/null 2>&1
        if [[ $? == 255 ]]; then
            deps+=" systemd-cryptsetup"
        fi
    fi

    echo "$deps"
    return 0
}

# called by dracut
install() {
    inst_script "$moddir/dracut-emergency.sh" /bin/dracut-emergency
    inst_simple "$moddir/emergency.service" "${systemdsystemunitdir}"/emergency.service
    inst_simple "$moddir/dracut-emergency.service" "${systemdsystemunitdir}"/dracut-emergency.service
    inst_simple "$moddir/emergency.service" "${systemdsystemunitdir}"/rescue.service

    ln_r "${systemdsystemunitdir}/initrd.target" "${systemdsystemunitdir}/default.target"

    inst_script "$moddir/dracut-cmdline.sh" /bin/dracut-cmdline
    inst_script "$moddir/dracut-cmdline-ask.sh" /bin/dracut-cmdline-ask
    inst_script "$moddir/dracut-pre-udev.sh" /bin/dracut-pre-udev
    inst_script "$moddir/dracut-pre-trigger.sh" /bin/dracut-pre-trigger
    inst_script "$moddir/dracut-initqueue.sh" /bin/dracut-initqueue
    inst_script "$moddir/dracut-pre-mount.sh" /bin/dracut-pre-mount
    inst_script "$moddir/dracut-mount.sh" /bin/dracut-mount
    inst_script "$moddir/dracut-pre-pivot.sh" /bin/dracut-pre-pivot

    inst_script "$moddir/rootfs-generator.sh" "$systemdutildir"/system-generators/dracut-rootfs-generator

    inst_hook cmdline 00 "$moddir/parse-root.sh"

    for i in \
        dracut-cmdline.service \
        dracut-cmdline-ask.service \
        dracut-initqueue.service \
        dracut-mount.service \
        dracut-pre-mount.service \
        dracut-pre-pivot.service \
        dracut-pre-trigger.service \
        dracut-pre-udev.service; do
        inst_simple "$moddir/${i}" "$systemdsystemunitdir/${i}"
        $SYSTEMCTL -q --root "$initdir" add-wants initrd.target "$i"
    done

    inst_simple "$moddir/dracut-tmpfiles.conf" "$tmpfilesdir/dracut-tmpfiles.conf"

    inst_multiple sulogin
}
