from pkgcheck import addons, reporters
from pkgcheck.checks import acct, cleanup, codingstyle, dropped_keywords, eclass, git, glsa, header, imlate, metadata, metadata_xml, network, overlays, perl, pkgdir, profiles, python, repo, repo_metadata, reserved, ruby, rust, stablereq, unstable_only, visibility, whitespace
KEYWORDS = (('ConflictingAccountIdentifiers', acct.ConflictingAccountIdentifiers), ('MissingAccountIdentifier', acct.MissingAccountIdentifier), ('OutsideRangeAccountIdentifier', acct.OutsideRangeAccountIdentifier), ('RedundantVersion', cleanup.RedundantVersion), ('AbsoluteSymlink', codingstyle.AbsoluteSymlink), ('BannedEapiCommand', codingstyle.BannedEapiCommand), ('BannedPhaseCall', codingstyle.BannedPhaseCall), ('BetterCompressionUri', codingstyle.BetterCompressionUri), ('DeprecatedEapiCommand', codingstyle.DeprecatedEapiCommand), ('DeprecatedInsinto', codingstyle.DeprecatedInsinto), ('DoublePrefixInPath', codingstyle.DoublePrefixInPath), ('DuplicateFunctionDefinition', codingstyle.DuplicateFunctionDefinition), ('EbuildUnquotedVariable', codingstyle.EbuildUnquotedVariable), ('EbuildVariableScope', codingstyle.EbuildVariableScope), ('EclassUnquotedVariable', codingstyle.EclassUnquotedVariable), ('EendMissingArg', codingstyle.EendMissingArg), ('EmptyGlobalAssignment', codingstyle.EmptyGlobalAssignment), ('ExcessiveLineLength', codingstyle.ExcessiveLineLength), ('GlobDistdir', codingstyle.GlobDistdir), ('HomepageInSrcUri', codingstyle.HomepageInSrcUri), ('IndirectInherits', codingstyle.IndirectInherits), ('InstallCompressedInfo', codingstyle.InstallCompressedInfo), ('InstallCompressedManpage', codingstyle.InstallCompressedManpage), ('InternalEclassUsage', codingstyle.InternalEclassUsage), ('InvalidSandboxCall', codingstyle.InvalidSandboxCall), ('MissingInherits', codingstyle.MissingInherits), ('MissingSlash', codingstyle.MissingSlash), ('MultipleKeywordsLines', codingstyle.MultipleKeywordsLines), ('NonPosixHeadTailUsage', codingstyle.NonPosixHeadTailUsage), ('ObsoleteUri', codingstyle.ObsoleteUri), ('ReadonlyVariable', codingstyle.ReadonlyVariable), ('RedundantDodir', codingstyle.RedundantDodir), ('ReferenceInMetadataVar', codingstyle.ReferenceInMetadataVar), ('SelfAssignment', codingstyle.SelfAssignment), ('StaticSrcUri', codingstyle.StaticSrcUri), ('UnnecessarySlashStrip', codingstyle.UnnecessarySlashStrip), ('UnquotedVariable', codingstyle.UnquotedVariable), ('UnusedInherits', codingstyle.UnusedInherits), ('VariableOrderWrong', codingstyle.VariableOrderWrong), ('VariableScope', codingstyle.VariableScope), ('VariableShadowed', codingstyle.VariableShadowed), ('DroppedKeywords', dropped_keywords.DroppedKeywords), ('DeprecatedEclass', eclass.DeprecatedEclass), ('DeprecatedEclassFunction', eclass.DeprecatedEclassFunction), ('DeprecatedEclassVariable', eclass.DeprecatedEclassVariable), ('DuplicateEclassInherit', eclass.DuplicateEclassInherit), ('EclassBashSyntaxError', eclass.EclassBashSyntaxError), ('EclassDocError', eclass.EclassDocError), ('EclassDocMissingFunc', eclass.EclassDocMissingFunc), ('EclassDocMissingVar', eclass.EclassDocMissingVar), ('EclassExportFuncsBeforeInherit', eclass.EclassExportFuncsBeforeInherit), ('EclassUserVariableUsage', eclass.EclassUserVariableUsage), ('EclassVariableScope', eclass.EclassVariableScope), ('GoMissingDeps', eclass.GoMissingDeps), ('MisplacedEclassVar', eclass.MisplacedEclassVar), ('ProvidedEclassInherit', eclass.ProvidedEclassInherit), ('RubyMissingDeps', eclass.RubyMissingDeps), ('RustMissingDeps', eclass.RustMissingDeps), ('TmpfilesMissingDeps', eclass.TmpfilesMissingDeps), ('BadCommitSummary', git.BadCommitSummary), ('DirectNoMaintainer', git.DirectNoMaintainer), ('DirectStableKeywords', git.DirectStableKeywords), ('DroppedStableKeywords', git.DroppedStableKeywords), ('DroppedUnstableKeywords', git.DroppedUnstableKeywords), ('EAPIChangeWithoutRevbump', git.EAPIChangeWithoutRevbump), ('EbuildIncorrectCopyright', git.EbuildIncorrectCopyright), ('EclassIncorrectCopyright', git.EclassIncorrectCopyright), ('IncorrectCopyright', git.IncorrectCopyright), ('InvalidCommitMessage', git.InvalidCommitMessage), ('InvalidCommitTag', git.InvalidCommitTag), ('MissingMove', git.MissingMove), ('MissingSignOff', git.MissingSignOff), ('MissingSlotmove', git.MissingSlotmove), ('NewerEAPIAvailable', git.NewerEAPIAvailable), ('OldPythonCompat', git.OldPythonCompat), ('PythonPEP517WithoutRevbump', git.PythonPEP517WithoutRevbump), ('RdependChange', git.RdependChange), ('SrcUriChecksumChange', git.SrcUriChecksumChange), ('SuspiciousSrcUriChange', git.SuspiciousSrcUriChange), ('VulnerablePackage', glsa.VulnerablePackage), ('EbuildInvalidCopyright', header.EbuildInvalidCopyright), ('EbuildInvalidLicenseHeader', header.EbuildInvalidLicenseHeader), ('EbuildNonGentooAuthorsCopyright', header.EbuildNonGentooAuthorsCopyright), ('EbuildOldGentooCopyright', header.EbuildOldGentooCopyright), ('EclassInvalidCopyright', header.EclassInvalidCopyright), ('EclassInvalidLicenseHeader', header.EclassInvalidLicenseHeader), ('EclassNonGentooAuthorsCopyright', header.EclassNonGentooAuthorsCopyright), ('EclassOldGentooCopyright', header.EclassOldGentooCopyright), ('InvalidCopyright', header.InvalidCopyright), ('InvalidLicenseHeader', header.InvalidLicenseHeader), ('NonGentooAuthorsCopyright', header.NonGentooAuthorsCopyright), ('OldGentooCopyright', header.OldGentooCopyright), ('LaggingStable', imlate.LaggingStable), ('PotentialStable', imlate.PotentialStable), ('BadDefaultUseFlags', metadata.BadDefaultUseFlags), ('BadDependency', metadata.BadDependency), ('BadDescription', metadata.BadDescription), ('BadFilename', metadata.BadFilename), ('BadHomepage', metadata.BadHomepage), ('BadKeywords', metadata.BadKeywords), ('BadProtocol', metadata.BadProtocol), ('BannedEapi', metadata.BannedEapi), ('DeprecatedDep', metadata.DeprecatedDep), ('DeprecatedEapi', metadata.DeprecatedEapi), ('DeprecatedLicense', metadata.DeprecatedLicense), ('DuplicateKeywords', metadata.DuplicateKeywords), ('InvalidBdepend', metadata.InvalidBdepend), ('InvalidDepend', metadata.InvalidDepend), ('InvalidEapi', metadata.InvalidEapi), ('InvalidIdepend', metadata.InvalidIdepend), ('InvalidLicense', metadata.InvalidLicense), ('InvalidPdepend', metadata.InvalidPdepend), ('InvalidProperties', metadata.InvalidProperties), ('InvalidRdepend', metadata.InvalidRdepend), ('InvalidRequiredUse', metadata.InvalidRequiredUse), ('InvalidRestrict', metadata.InvalidRestrict), ('InvalidSlot', metadata.InvalidSlot), ('InvalidSrcUri', metadata.InvalidSrcUri), ('InvalidUseFlags', metadata.InvalidUseFlags), ('MatchingGlobalUse', metadata.MatchingGlobalUse), ('MisplacedWeakBlocker', metadata.MisplacedWeakBlocker), ('MissingLicense', metadata.MissingLicense), ('MissingLicenseRestricts', metadata.MissingLicenseRestricts), ('MissingLocalUseDesc', metadata.MissingLocalUseDesc), ('MissingPackageRevision', metadata.MissingPackageRevision), ('MissingSlotDep', metadata.MissingSlotDep), ('MissingTestRestrict', metadata.MissingTestRestrict), ('MissingUnpackerDep', metadata.MissingUnpackerDep), ('MissingUri', metadata.MissingUri), ('MissingUseDepDefault', metadata.MissingUseDepDefault), ('NonexistentBlocker', metadata.NonexistentBlocker), ('OutdatedBlocker', metadata.OutdatedBlocker), ('OverlappingKeywords', metadata.OverlappingKeywords), ('ProbableGlobalUse', metadata.ProbableGlobalUse), ('ProbableUseExpand', metadata.ProbableUseExpand), ('RedundantUriRename', metadata.RedundantUriRename), ('RequiredUseDefaults', metadata.RequiredUseDefaults), ('SourcingError', metadata.SourcingError), ('SrcUriFilenameDotPrefix', metadata.SrcUriFilenameDotPrefix), ('StableKeywordsOnTestingEapi', metadata.StableKeywordsOnTestingEapi), ('StaleLiveEAPI', metadata.StaleLiveEAPI), ('TarballAvailable', metadata.TarballAvailable), ('UnderscoreInUseFlag', metadata.UnderscoreInUseFlag), ('UnknownKeywords', metadata.UnknownKeywords), ('UnknownLicense', metadata.UnknownLicense), ('UnknownMirror', metadata.UnknownMirror), ('UnknownProperties', metadata.UnknownProperties), ('UnknownRestrict', metadata.UnknownRestrict), ('UnknownUseFlags', metadata.UnknownUseFlags), ('UnnecessaryLicense', metadata.UnnecessaryLicense), ('UnsortedKeywords', metadata.UnsortedKeywords), ('UnstableSrcUri', metadata.UnstableSrcUri), ('UnstatedIuse', addons.UnstatedIuse), ('UnsupportedEclassEapi', metadata.UnsupportedEclassEapi), ('UnusedLocalUse', metadata.UnusedLocalUse), ('UseFlagWithoutDeps', metadata.UseFlagWithoutDeps), ('VirtualKeywordsUpdate', metadata.VirtualKeywordsUpdate), ('VirtualWithBdepend', metadata.VirtualWithBdepend), ('VirtualWithDepend', metadata.VirtualWithDepend), ('VirtualWithSingleProvider', metadata.VirtualWithSingleProvider), ('CatBadlyFormedXml', metadata_xml.CatBadlyFormedXml), ('CatInvalidXml', metadata_xml.CatInvalidXml), ('CatMetadataXmlEmptyElement', metadata_xml.CatMetadataXmlEmptyElement), ('CatMetadataXmlIndentation', metadata_xml.CatMetadataXmlIndentation), ('CatMetadataXmlInvalidCatRef', metadata_xml.CatMetadataXmlInvalidCatRef), ('CatMetadataXmlInvalidPkgRef', metadata_xml.CatMetadataXmlInvalidPkgRef), ('CatMissingMetadataXml', metadata_xml.CatMissingMetadataXml), ('InvalidMetadataRestrict', metadata_xml.InvalidMetadataRestrict), ('InvalidRemoteID', metadata_xml.InvalidRemoteID), ('MaintainerNeeded', metadata_xml.MaintainerNeeded), ('MaintainerWithoutProxy', metadata_xml.MaintainerWithoutProxy), ('MissingRemoteId', metadata_xml.MissingRemoteId), ('NonexistentProjectMaintainer', metadata_xml.NonexistentProjectMaintainer), ('PkgBadlyFormedXml', metadata_xml.PkgBadlyFormedXml), ('PkgInvalidXml', metadata_xml.PkgInvalidXml), ('PkgMetadataXmlEmptyElement', metadata_xml.PkgMetadataXmlEmptyElement), ('PkgMetadataXmlIndentation', metadata_xml.PkgMetadataXmlIndentation), ('PkgMetadataXmlInvalidCatRef', metadata_xml.PkgMetadataXmlInvalidCatRef), ('PkgMetadataXmlInvalidPkgRef', metadata_xml.PkgMetadataXmlInvalidPkgRef), ('PkgMissingMetadataXml', metadata_xml.PkgMissingMetadataXml), ('ProxyWithoutProxied', metadata_xml.ProxyWithoutProxied), ('RedundantLongDescription', metadata_xml.RedundantLongDescription), ('WrongMaintainerType', metadata_xml.WrongMaintainerType), ('DeadUrl', network.DeadUrl), ('HttpsUrlAvailable', network.HttpsUrlAvailable), ('RedirectedUrl', network.RedirectedUrl), ('SSLCertificateError', network.SSLCertificateError), ('UnusedInMastersEclasses', overlays.UnusedInMastersEclasses), ('UnusedInMastersGlobalUse', overlays.UnusedInMastersGlobalUse), ('UnusedInMastersLicenses', overlays.UnusedInMastersLicenses), ('UnusedInMastersMirrors', overlays.UnusedInMastersMirrors), ('MismatchedPerlVersion', perl.MismatchedPerlVersion), ('MissingVersionedVirtualPerlDependency', perl.MissingVersionedVirtualPerlDependency), ('BannedCharacter', pkgdir.BannedCharacter), ('DuplicateFiles', pkgdir.DuplicateFiles), ('EmptyFile', pkgdir.EmptyFile), ('EqualVersions', pkgdir.EqualVersions), ('ExecutableFile', pkgdir.ExecutableFile), ('InvalidPN', pkgdir.InvalidPN), ('InvalidUTF8', pkgdir.InvalidUTF8), ('LiveOnlyPackage', pkgdir.LiveOnlyPackage), ('MismatchedPN', pkgdir.MismatchedPN), ('SizeViolation', pkgdir.SizeViolation), ('TotalSizeViolation', pkgdir.TotalSizeViolation), ('UnknownPkgDirEntry', pkgdir.UnknownPkgDirEntry), ('ArchesOutOfSync', profiles.ArchesOutOfSync), ('ArchesWithoutProfiles', profiles.ArchesWithoutProfiles), ('BannedProfileEapi', profiles.BannedProfileEapi), ('DeprecatedProfileEapi', profiles.DeprecatedProfileEapi), ('LaggingProfileEapi', profiles.LaggingProfileEapi), ('NonexistentCategories', profiles.NonexistentCategories), ('NonexistentProfilePath', profiles.NonexistentProfilePath), ('OutdatedProfilePackage', profiles.OutdatedProfilePackage), ('ProfileError', profiles.ProfileError), ('ProfileMissingImplicitExpandValues', profiles.ProfileMissingImplicitExpandValues), ('ProfileWarning', profiles.ProfileWarning), ('UnknownCategoryDirs', profiles.UnknownCategoryDirs), ('UnknownProfileArch', profiles.UnknownProfileArch), ('UnknownProfilePackage', profiles.UnknownProfilePackage), ('UnknownProfilePackageKeywords', profiles.UnknownProfilePackageKeywords), ('UnknownProfilePackageUse', profiles.UnknownProfilePackageUse), ('UnknownProfileUse', profiles.UnknownProfileUse), ('UnknownProfileUseExpand', profiles.UnknownProfileUseExpand), ('UnknownProfileUseExpandValue', profiles.UnknownProfileUseExpandValue), ('UnmatchedProfilePackageUnmask', profiles.UnmatchedProfilePackageUnmask), ('UnusedProfileDirs', profiles.UnusedProfileDirs), ('DistutilsNonPEP517Build', python.DistutilsNonPEP517Build), ('MissingPythonEclass', python.MissingPythonEclass), ('PythonAnyMismatchedDepHasVersionCheck', python.PythonAnyMismatchedDepHasVersionCheck), ('PythonAnyMismatchedUseHasVersionCheck', python.PythonAnyMismatchedUseHasVersionCheck), ('PythonCompatUpdate', python.PythonCompatUpdate), ('PythonEclassError', python.PythonEclassError), ('PythonGHDistfileSuffix', python.PythonGHDistfileSuffix), ('PythonHasVersionMissingPythonUseDep', python.PythonHasVersionMissingPythonUseDep), ('PythonHasVersionUsage', python.PythonHasVersionUsage), ('PythonInlinePyPIURI', python.PythonInlinePyPIURI), ('PythonMismatchedPackageName', python.PythonMismatchedPackageName), ('PythonMissingDeps', python.PythonMissingDeps), ('PythonMissingRequiredUse', python.PythonMissingRequiredUse), ('PythonMissingSCMDependency', python.PythonMissingSCMDependency), ('PythonRuntimeDepInAnyR1', python.PythonRuntimeDepInAnyR1), ('BinaryFile', repo.BinaryFile), ('CategoryIsNotDirectory', repo.CategoryIsNotDirectory), ('EmptyCategoryDir', repo.EmptyCategoryDir), ('EmptyPackageDir', repo.EmptyPackageDir), ('BadPackageUpdate', repo_metadata.BadPackageUpdate), ('ConflictingChksums', repo_metadata.ConflictingChksums), ('DeprecatedChksum', repo_metadata.DeprecatedChksum), ('DeprecatedManifestHash', repo_metadata.DeprecatedManifestHash), ('DeprecatedRepoHash', repo_metadata.DeprecatedRepoHash), ('EmptyProject', repo_metadata.EmptyProject), ('InvalidManifest', repo_metadata.InvalidManifest), ('MatchingChksums', repo_metadata.MatchingChksums), ('MissingChksum', repo_metadata.MissingChksum), ('MissingManifest', repo_metadata.MissingManifest), ('MovedPackageUpdate', repo_metadata.MovedPackageUpdate), ('MultiMovePackageUpdate', repo_metadata.MultiMovePackageUpdate), ('OldMultiMovePackageUpdate', repo_metadata.OldMultiMovePackageUpdate), ('OldPackageUpdate', repo_metadata.OldPackageUpdate), ('PotentialGlobalUse', repo_metadata.PotentialGlobalUse), ('PotentialLocalUse', repo_metadata.PotentialLocalUse), ('RedundantPackageUpdate', repo_metadata.RedundantPackageUpdate), ('UnknownLicenses', repo_metadata.UnknownLicenses), ('UnknownManifest', repo_metadata.UnknownManifest), ('UnnecessaryManifest', repo_metadata.UnnecessaryManifest), ('UnusedEclasses', repo_metadata.UnusedEclasses), ('UnusedGlobalUse', repo_metadata.UnusedGlobalUse), ('UnusedGlobalUseExpand', repo_metadata.UnusedGlobalUseExpand), ('UnusedLicenses', repo_metadata.UnusedLicenses), ('UnusedMirrors', repo_metadata.UnusedMirrors), ('EbuildReservedName', reserved.EbuildReservedName), ('EbuildSemiReservedName', reserved.EbuildSemiReservedName), ('EclassReservedName', reserved.EclassReservedName), ('RubyCompatUpdate', ruby.RubyCompatUpdate), ('SuboptimalCratesSeparator', rust.SuboptimalCratesSeparator), ('SuboptimalCratesURICall', rust.SuboptimalCratesURICall), ('StableRequest', stablereq.StableRequest), ('UnstableOnly', unstable_only.UnstableOnly), ('DependencyMoved', visibility.DependencyMoved), ('NonexistentDeps', visibility.NonexistentDeps), ('NonsolvableDeps', visibility.NonsolvableDeps), ('NonsolvableDepsInDev', visibility.NonsolvableDepsInDev), ('NonsolvableDepsInExp', visibility.NonsolvableDepsInExp), ('NonsolvableDepsInStable', visibility.NonsolvableDepsInStable), ('OldPackageName', visibility.OldPackageName), ('OldPackageNameDep', visibility.OldPackageNameDep), ('UncheckableDep', visibility.UncheckableDep), ('VisibleVcsPkg', visibility.VisibleVcsPkg), ('BadWhitespaceCharacter', whitespace.BadWhitespaceCharacter), ('DoubleEmptyLine', whitespace.DoubleEmptyLine), ('MissingEAPIBlankLine', whitespace.MissingEAPIBlankLine), ('NoFinalNewline', whitespace.NoFinalNewline), ('TrailingEmptyLine', whitespace.TrailingEmptyLine), ('WhitespaceFound', whitespace.WhitespaceFound), ('WrongIndentFound', whitespace.WrongIndentFound))
CHECKS = (('AcctCheck', acct.AcctCheck), ('RedundantVersionCheck', cleanup.RedundantVersionCheck), ('AbsoluteSymlinkCheck', codingstyle.AbsoluteSymlinkCheck), ('BadCommandsCheck', codingstyle.BadCommandsCheck), ('BetterCompressionCheck', codingstyle.BetterCompressionCheck), ('DeclarationShadowedCheck', codingstyle.DeclarationShadowedCheck), ('DoCompressedFilesCheck', codingstyle.DoCompressedFilesCheck), ('EbuildUnquotedVariablesCheck', codingstyle.EbuildUnquotedVariablesCheck), ('EclassUnquotedVariablesCheck', codingstyle.EclassUnquotedVariablesCheck), ('EendMissingArgCheck', codingstyle.EendMissingArgCheck), ('GlobCheck', codingstyle.GlobCheck), ('InheritsCheck', codingstyle.InheritsCheck), ('InsintoCheck', codingstyle.InsintoCheck), ('LineLengthCheck', codingstyle.LineLengthCheck), ('MetadataVarCheck', codingstyle.MetadataVarCheck), ('NonPosixCheck', codingstyle.NonPosixCheck), ('ObsoleteUriCheck', codingstyle.ObsoleteUriCheck), ('PathVariablesCheck', codingstyle.PathVariablesCheck), ('ReadonlyVariableCheck', codingstyle.ReadonlyVariableCheck), ('RedundantDodirCheck', codingstyle.RedundantDodirCheck), ('SandboxCallCheck', codingstyle.SandboxCallCheck), ('VariableOrderCheck', codingstyle.VariableOrderCheck), ('VariableScopeCheck', codingstyle.VariableScopeCheck), ('DroppedKeywordsCheck', dropped_keywords.DroppedKeywordsCheck), ('EclassCheck', eclass.EclassCheck), ('EclassManualDepsCheck', eclass.EclassManualDepsCheck), ('EclassParseCheck', eclass.EclassParseCheck), ('EclassUsageCheck', eclass.EclassUsageCheck), ('GitCommitMessageCheck', git.GitCommitMessageCheck), ('GitEclassCommitsCheck', git.GitEclassCommitsCheck), ('GitPkgCommitsCheck', git.GitPkgCommitsCheck), ('GlsaCheck', glsa.GlsaCheck), ('EbuildHeaderCheck', header.EbuildHeaderCheck), ('EclassHeaderCheck', header.EclassHeaderCheck), ('ImlateCheck', imlate.ImlateCheck), ('DependencyCheck', metadata.DependencyCheck), ('DescriptionCheck', metadata.DescriptionCheck), ('EapiCheck', metadata.EapiCheck), ('HomepageCheck', metadata.HomepageCheck), ('IuseCheck', metadata.IuseCheck), ('KeywordsCheck', metadata.KeywordsCheck), ('LicenseCheck', metadata.LicenseCheck), ('LocalUseCheck', metadata.LocalUseCheck), ('MissingSlotDepCheck', metadata.MissingSlotDepCheck), ('MissingUnpackerDepCheck', metadata.MissingUnpackerDepCheck), ('OutdatedBlockersCheck', metadata.OutdatedBlockersCheck), ('PropertiesCheck', metadata.PropertiesCheck), ('RequiredUseCheck', metadata.RequiredUseCheck), ('RestrictCheck', metadata.RestrictCheck), ('RestrictTestCheck', metadata.RestrictTestCheck), ('SourcingCheck', metadata.SourcingCheck), ('SrcUriCheck', metadata.SrcUriCheck), ('StaleLiveCheck', metadata.StaleLiveCheck), ('UseFlagsWithoutEffectsCheck', metadata.UseFlagsWithoutEffectsCheck), ('VirtualProvidersCheck', metadata.VirtualProvidersCheck), ('CategoryMetadataXmlCheck', metadata_xml.CategoryMetadataXmlCheck), ('MissingRemoteIdCheck', metadata_xml.MissingRemoteIdCheck), ('PackageMetadataXmlCheck', metadata_xml.PackageMetadataXmlCheck), ('FetchablesUrlCheck', network.FetchablesUrlCheck), ('HomepageUrlCheck', network.HomepageUrlCheck), ('MetadataUrlCheck', network.MetadataUrlCheck), ('UnusedInMastersCheck', overlays.UnusedInMastersCheck), ('PerlCheck', perl.PerlCheck), ('EqualVersionsCheck', pkgdir.EqualVersionsCheck), ('LiveOnlyCheck', pkgdir.LiveOnlyCheck), ('PkgDirCheck', pkgdir.PkgDirCheck), ('ProfilesCheck', profiles.ProfilesCheck), ('RepoProfilesCheck', profiles.RepoProfilesCheck), ('PythonCheck', python.PythonCheck), ('PythonCompatCheck', python.PythonCompatCheck), ('PythonFetchableCheck', python.PythonFetchableCheck), ('PythonPackageNameCheck', python.PythonPackageNameCheck), ('EmptyDirsCheck', repo.EmptyDirsCheck), ('RepoDirCheck', repo.RepoDirCheck), ('RepositoryCategories', repo.RepositoryCategories), ('GlobalUseCheck', repo_metadata.GlobalUseCheck), ('LicenseGroupsCheck', repo_metadata.LicenseGroupsCheck), ('ManifestCheck', repo_metadata.ManifestCheck), ('ManifestCollisionCheck', repo_metadata.ManifestCollisionCheck), ('PackageUpdatesCheck', repo_metadata.PackageUpdatesCheck), ('ProjectMetadataCheck', repo_metadata.ProjectMetadataCheck), ('RepoManifestHashCheck', repo_metadata.RepoManifestHashCheck), ('UnusedEclassesCheck', repo_metadata.UnusedEclassesCheck), ('UnusedLicensesCheck', repo_metadata.UnusedLicensesCheck), ('UnusedMirrorsCheck', repo_metadata.UnusedMirrorsCheck), ('EbuildReservedCheck', reserved.EbuildReservedCheck), ('EclassReservedCheck', reserved.EclassReservedCheck), ('RubyCompatCheck', ruby.RubyCompatCheck), ('RustCheck', rust.RustCheck), ('StableRequestCheck', stablereq.StableRequestCheck), ('UnstableOnlyCheck', unstable_only.UnstableOnlyCheck), ('VisibilityCheck', visibility.VisibilityCheck), ('MissingWhitespaceCheck', whitespace.MissingWhitespaceCheck), ('WhitespaceCheck', whitespace.WhitespaceCheck))
REPORTERS = (('CsvReporter', reporters.CsvReporter), ('FancyReporter', reporters.FancyReporter), ('FlycheckReporter', reporters.FlycheckReporter), ('FormatReporter', reporters.FormatReporter), ('JsonReporter', reporters.JsonReporter), ('JsonStream', reporters.JsonStream), ('StrReporter', reporters.StrReporter), ('XmlReporter', reporters.XmlReporter))
