# This file is generated by SciPy's build process
# It contains system_info results at the time of building this package.
from enum import Enum

__all__ = ["show"]
_built_with_meson = True


class DisplayModes(Enum):
    stdout = "stdout"
    dicts = "dicts"


def _cleanup(d):
    """
    Removes empty values in a `dict` recursively
    This ensures we remove values that Meson could not provide to CONFIG
    """
    if isinstance(d, dict):
        return { k: _cleanup(v) for k, v in d.items() if v != '' and _cleanup(v) != '' }
    else:
        return d


CONFIG = _cleanup(
    {
        "Compilers": {
            "c": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.1",
                "commands": r"x86_64-pc-linux-gnu-gcc",
                "args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake, -frecord-gcc-switches, -fdiagnostics-color=never, -mavx, -mavx2, -mfma, -DNDEBUG",
                "linker args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake, -frecord-gcc-switches, -fdiagnostics-color=never, -mavx, -mavx2, -mfma, -v, -Wl,-O1, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-O2, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-z,relro, -Wl,-z,now",
            },
            "cython": {
                "name": r"cython",
                "linker": r"cython",
                "version": r"3.0.11",
                "commands": r"cython",
                "args": r"",
                "linker args": r"",
            },
            "c++": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.1",
                "commands": r"x86_64-pc-linux-gnu-g++",
                "args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake, -frecord-gcc-switches, -fdiagnostics-color=never, -mavx, -mavx2, -mfma, -DNDEBUG",
                "linker args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake, -frecord-gcc-switches, -fdiagnostics-color=never, -mavx, -mavx2, -mfma, -v, -Wl,-O1, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-O2, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-z,relro, -Wl,-z,now",
            },
            "fortran": {
                "name": "gcc",
                "linker": r"ld.bfd",
                "version": "13.3.1",
                "commands": r"x86_64-pc-linux-gnu-gfortran",
                "args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake",
                "linker args": r"-O3, -pipe, -march=ivybridge, -mtune=skylake, -v, -Wl,-O1, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-O2, -Wl,--as-needed, -Wl,-z,pack-relative-relocs, -Wl,-z,relro, -Wl,-z,now",
            },
            "pythran": {
                "version": r"0.16.1",
                "include directory": r"../../../../../../../../usr/lib/python3.11/site-packages/pythran"
            },
        },
        "Machine Information": {
            "host": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "build": {
                "cpu": r"x86_64",
                "family": r"x86_64",
                "endian": r"little",
                "system": r"linux",
            },
            "cross-compiled": bool("False".lower().replace('false', '')),
        },
        "Build Dependencies": {
            "blas": {
                "name": "blas",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/include",
                "lib directory": r"/usr/lib64",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/lib64/pkgconfig",
            },
            "lapack": {
                "name": "lapack",
                "found": bool("True".lower().replace('false', '')),
                "version": "3.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/usr/include",
                "lib directory": r"/usr/lib64",
                "openblas configuration": r"unknown",
                "pc file directory": r"/usr/lib64/pkgconfig",
            },
            "pybind11": {
                "name": "pybind11",
                "version": "2.12.0",
                "detection method": "pkgconfig",
                "include directory": r"/include",
            },
        },
        "Python Information": {
            "path": r"/usr/bin/python3.11",
            "version": "3.11",
        },
    }
)


def _check_pyyaml():
    import yaml

    return yaml


def show(mode=DisplayModes.stdout.value):
    """
    Show libraries and system information on which SciPy was built
    and is being used

    Parameters
    ----------
    mode : {`'stdout'`, `'dicts'`}, optional.
        Indicates how to display the config information.
        `'stdout'` prints to console, `'dicts'` returns a dictionary
        of the configuration.

    Returns
    -------
    out : {`dict`, `None`}
        If mode is `'dicts'`, a dict is returned, else None

    Notes
    -----
    1. The `'stdout'` mode will give more readable
       output if ``pyyaml`` is installed

    """
    if mode == DisplayModes.stdout.value:
        try:  # Non-standard library, check import
            yaml = _check_pyyaml()

            print(yaml.dump(CONFIG))
        except ModuleNotFoundError:
            import warnings
            import json

            warnings.warn("Install `pyyaml` for better output", stacklevel=1)
            print(json.dumps(CONFIG, indent=2))
    elif mode == DisplayModes.dicts.value:
        return CONFIG
    else:
        raise AttributeError(
            f"Invalid `mode`, use one of: {', '.join([e.value for e in DisplayModes])}"
        )
