# Copyright 2024-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

# Autogenerated by pycargoebuild 0.13.4

EAPI=8

CRATES="
	addr2line@0.22.0
	adler2@2.0.0
	adler@1.0.2
	ahash@0.8.11
	aho-corasick@1.1.3
	allocator-api2@0.2.18
	android-tzdata@0.1.1
	android_system_properties@0.1.5
	anyhow@1.0.95
	arc-swap@1.7.1
	autocfg@1.3.0
	backtrace@0.3.73
	bitflags@2.6.0
	bstr@1.10.0
	bumpalo@3.16.0
	bytes@1.7.1
	cassowary@0.3.0
	cc@1.2.6
	cfg-if@1.0.0
	chardetng@0.1.17
	chrono@0.4.39
	clipboard-win@5.4.0
	clru@0.6.2
	content_inspector@0.2.4
	core-foundation-sys@0.8.7
	crc32fast@1.4.2
	crossbeam-deque@0.8.5
	crossbeam-epoch@0.9.18
	crossbeam-utils@0.8.20
	crossterm@0.28.1
	crossterm_winapi@0.9.1
	dashmap@6.1.0
	displaydoc@0.2.5
	dunce@1.0.5
	either@1.13.0
	encoding_rs@0.8.35
	encoding_rs_io@0.1.7
	env_home@0.1.0
	equivalent@1.0.1
	errno@0.3.10
	error-code@3.2.0
	etcetera@0.8.0
	faster-hex@0.9.0
	fastrand@2.1.1
	fern@0.7.1
	filedescriptor@0.8.2
	filetime@0.2.25
	flate2@1.0.33
	fnv@1.0.7
	form_urlencoded@1.2.1
	futures-core@0.3.31
	futures-executor@0.3.31
	futures-task@0.3.31
	futures-util@0.3.31
	getrandom@0.2.15
	gimli@0.29.0
	gix-actor@0.33.1
	gix-attributes@0.23.1
	gix-bitmap@0.2.13
	gix-chunk@0.4.10
	gix-command@0.4.0
	gix-commitgraph@0.25.1
	gix-config-value@0.14.10
	gix-config@0.42.0
	gix-date@0.9.3
	gix-diff@0.49.0
	gix-dir@0.11.0
	gix-discover@0.37.0
	gix-features@0.39.1
	gix-filter@0.16.0
	gix-fs@0.12.1
	gix-glob@0.17.1
	gix-hash@0.15.1
	gix-hashtable@0.6.0
	gix-ignore@0.12.1
	gix-index@0.37.0
	gix-lock@15.0.0
	gix-object@0.46.1
	gix-odb@0.66.0
	gix-pack@0.56.0
	gix-packetline-blocking@0.18.1
	gix-packetline@0.18.2
	gix-path@0.10.13
	gix-pathspec@0.8.1
	gix-protocol@0.47.0
	gix-quote@0.4.14
	gix-ref@0.49.1
	gix-refspec@0.27.0
	gix-revision@0.31.1
	gix-revwalk@0.17.0
	gix-sec@0.10.10
	gix-shallow@0.1.0
	gix-status@0.16.0
	gix-submodule@0.16.0
	gix-tempfile@15.0.0
	gix-trace@0.1.11
	gix-transport@0.44.0
	gix-traverse@0.43.1
	gix-url@0.28.2
	gix-utils@0.1.13
	gix-validate@0.9.2
	gix-worktree@0.38.0
	gix@0.69.1
	globset@0.4.15
	grep-matcher@0.1.7
	grep-regex@0.1.13
	grep-searcher@0.1.14
	hashbrown@0.14.5
	hermit-abi@0.3.9
	home@0.5.9
	iana-time-zone-haiku@0.1.2
	iana-time-zone@0.1.60
	icu_collections@1.5.0
	icu_locid@1.5.0
	icu_locid_transform@1.5.0
	icu_locid_transform_data@1.5.0
	icu_normalizer@1.5.0
	icu_normalizer_data@1.5.0
	icu_properties@1.5.1
	icu_properties_data@1.5.0
	icu_provider@1.5.0
	icu_provider_macros@1.5.0
	idna@1.0.3
	idna_adapter@1.2.0
	ignore@0.4.23
	imara-diff@0.1.7
	indexmap@2.5.0
	indoc@2.0.5
	is-docker@0.2.0
	is-wsl@0.4.0
	itoa@1.0.11
	jiff-tzdb-platform@0.1.1
	jiff-tzdb@0.1.1
	jiff@0.1.13
	js-sys@0.3.70
	kstring@2.0.2
	libc@0.2.169
	libloading@0.8.6
	libredox@0.1.3
	linux-raw-sys@0.4.14
	litemap@0.7.3
	lock_api@0.4.12
	log@0.4.22
	maybe-async@0.2.10
	memchr@2.7.4
	memmap2@0.9.4
	miniz_oxide@0.7.4
	miniz_oxide@0.8.0
	mio@1.0.2
	nucleo-matcher@0.3.1
	nucleo@0.5.0
	num-traits@0.2.19
	num_cpus@1.16.0
	object@0.36.4
	once_cell@1.20.2
	open@5.3.1
	parking_lot@0.12.3
	parking_lot_core@0.9.10
	pathdiff@0.2.1
	percent-encoding@2.3.1
	pin-project-lite@0.2.14
	pin-utils@0.1.0
	portable-atomic@1.7.0
	proc-macro2@1.0.86
	prodash@29.0.0
	pulldown-cmark@0.12.2
	quickcheck@1.0.3
	quote@1.0.37
	rand@0.8.5
	rand_core@0.6.4
	rayon-core@1.12.1
	rayon@1.10.0
	redox_syscall@0.5.3
	regex-automata@0.4.9
	regex-cursor@0.1.4
	regex-syntax@0.8.5
	regex@1.11.1
	ropey@1.6.1
	rustc-demangle@0.1.24
	rustix@0.38.42
	ryu@1.0.18
	same-file@1.0.6
	scopeguard@1.2.0
	serde@1.0.217
	serde_derive@1.0.217
	serde_json@1.0.134
	serde_repr@0.1.19
	serde_spanned@0.6.7
	sha1_smol@1.0.1
	shell-words@1.1.0
	shlex@1.3.0
	signal-hook-mio@0.2.4
	signal-hook-registry@1.4.2
	signal-hook-tokio@0.3.1
	signal-hook@0.3.17
	slab@0.4.9
	slotmap@1.0.7
	smallvec@1.13.2
	smartstring@1.0.1
	smawk@0.3.2
	socket2@0.5.7
	stable_deref_trait@1.2.0
	static_assertions@1.1.0
	str_indices@0.4.3
	syn@2.0.87
	synstructure@0.13.1
	tempfile@3.14.0
	termini@1.0.0
	textwrap@0.16.1
	thiserror-impl@1.0.69
	thiserror-impl@2.0.9
	thiserror@1.0.69
	thiserror@2.0.9
	threadpool@1.8.1
	tinystr@0.7.6
	tinyvec@1.8.0
	tinyvec_macros@0.1.1
	tokio-macros@2.4.0
	tokio-stream@0.1.17
	tokio@1.42.0
	toml@0.8.19
	toml_datetime@0.6.8
	toml_edit@0.22.20
	tree-sitter@0.22.6
	unicase@2.7.0
	unicode-bom@2.0.3
	unicode-general-category@1.0.0
	unicode-ident@1.0.12
	unicode-linebreak@0.1.5
	unicode-normalization@0.1.23
	unicode-segmentation@1.12.0
	unicode-width@0.1.12
	url@2.5.4
	utf16_iter@1.0.5
	utf8_iter@1.0.4
	version_check@0.9.5
	walkdir@2.5.0
	wasi@0.11.0+wasi-snapshot-preview1
	wasm-bindgen-backend@0.2.93
	wasm-bindgen-macro-support@0.2.93
	wasm-bindgen-macro@0.2.93
	wasm-bindgen-shared@0.2.93
	wasm-bindgen@0.2.93
	which@7.0.1
	winapi-i686-pc-windows-gnu@0.4.0
	winapi-util@0.1.9
	winapi-x86_64-pc-windows-gnu@0.4.0
	winapi@0.3.9
	windows-core@0.52.0
	windows-sys@0.48.0
	windows-sys@0.52.0
	windows-sys@0.59.0
	windows-targets@0.48.5
	windows-targets@0.52.6
	windows_aarch64_gnullvm@0.48.5
	windows_aarch64_gnullvm@0.52.6
	windows_aarch64_msvc@0.48.5
	windows_aarch64_msvc@0.52.6
	windows_i686_gnu@0.48.5
	windows_i686_gnu@0.52.6
	windows_i686_gnullvm@0.52.6
	windows_i686_msvc@0.48.5
	windows_i686_msvc@0.52.6
	windows_x86_64_gnu@0.48.5
	windows_x86_64_gnu@0.52.6
	windows_x86_64_gnullvm@0.48.5
	windows_x86_64_gnullvm@0.52.6
	windows_x86_64_msvc@0.48.5
	windows_x86_64_msvc@0.52.6
	winnow@0.6.18
	winsafe@0.0.19
	write16@1.0.0
	writeable@0.5.5
	yoke-derive@0.7.4
	yoke@0.7.4
	zerocopy-derive@0.7.35
	zerocopy@0.7.35
	zerofrom-derive@0.1.4
	zerofrom@0.1.4
	zerovec-derive@0.10.3
	zerovec@0.10.4
"

RUST_MIN_VER="1.76"

inherit cargo desktop shell-completion xdg

DESCRIPTION="A post-modern text editor"
HOMEPAGE="
	https://helix-editor.com/
	https://github.com/helix-editor/helix
"
SRC_URI="
	https://github.com/helix-editor/helix/releases/download/${PV}/${P}-source.tar.xz -> ${P}.tar.xz
	${CARGO_CRATE_URIS}
"
S="${WORKDIR}"

LICENSE="MPL-2.0"
# Dependent crate licenses
LICENSE+="
	Apache-2.0 BSD Boost-1.0 ISC MIT MPL-2.0 MPL-2.0 Unicode-DFS-2016
	ZLIB
"
SLOT="0"
KEYWORDS="amd64"
IUSE="+grammar"

RDEPEND="dev-vcs/git"

pkg_setup() {
	QA_FLAGS_IGNORED="
		usr/bin/hx
		/usr/$(get_libdir)/helix/.*\.so
	"
	export HELIX_DEFAULT_RUNTIME="${EPREFIX}/usr/share/${PN}/runtime"
	use grammar || export HELIX_DISABLE_AUTO_GRAMMAR_BUILD=1
	rust_pkg_setup
}

src_install() {
	cargo_src_install --path helix-term

	insinto "/usr/$(get_libdir)/${PN}"
	use grammar && doins runtime/grammars/*.so
	rm -r runtime/grammars || die
	use grammar && dosym "../../../$(get_libdir)/${PN}" "${EPREFIX}/usr/share/${PN}/runtime/grammars"

	insinto /usr/share/helix
	doins -r runtime

	doicon -s 256x256 contrib/${PN}.png
	domenu contrib/Helix.desktop

	insinto /usr/share/metainfo
	doins contrib/Helix.appdata.xml

	newbashcomp contrib/completion/hx.bash hx
	newzshcomp contrib/completion/hx.zsh _hx
	dofishcomp contrib/completion/hx.fish

	DOCS=(
		README.md
		CHANGELOG.md
		docs/
	)
	HTML_DOCS=(
		book/
	)
	einstalldocs
}

pkg_postinst() {
	if ! use grammar ; then
		einfo "Grammars are not installed yet. To fetch them, run:"
		einfo ""
		einfo "  hx --grammar fetch && hx --grammar build"
	fi

	xdg_desktop_database_update
	xdg_icon_cache_update
}

pkg_postrm() {
	xdg_desktop_database_update
	xdg_icon_cache_update
}
