
#ifndef QUICKCHARTS_EXPORT_H
#define QUICKCHARTS_EXPORT_H

#ifdef QUICKCHARTS_STATIC_DEFINE
#  define QUICKCHARTS_EXPORT
#  define QUICKCHARTS_NO_EXPORT
#else
#  ifndef QUICKCHARTS_EXPORT
#    ifdef QuickCharts_EXPORTS
        /* We are building this library */
#      define QUICKCHARTS_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define QUICKCHARTS_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef QUICKCHARTS_NO_EXPORT
#    define QUICKCHARTS_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef QUICKCHARTS_DECL_DEPRECATED
#  define QUICKCHARTS_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef QUICKCHARTS_DECL_DEPRECATED_EXPORT
#  define QUICKCHARTS_DECL_DEPRECATED_EXPORT QUICKCHARTS_EXPORT QUICKCHARTS_DECL_DEPRECATED
#endif

#ifndef QUICKCHARTS_DECL_DEPRECATED_NO_EXPORT
#  define QUICKCHARTS_DECL_DEPRECATED_NO_EXPORT QUICKCHARTS_NO_EXPORT QUICKCHARTS_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef QUICKCHARTS_NO_DEPRECATED
#    define QUICKCHARTS_NO_DEPRECATED
#  endif
#endif

#define QUICKCHARTS_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(QUICKCHARTS_NO_DEPRECATED) && !defined(QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define QUICKCHARTS_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(QUICKCHARTS_NO_DEPRECATED_WARNINGS) && !defined(QUICKCHARTS_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define QUICKCHARTS_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define QUICKCHARTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(QUICKCHARTS_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define QUICKCHARTS_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(QUICKCHARTS_NO_DEPRECATED)
#  undef QUICKCHARTS_DEPRECATED
#  define QUICKCHARTS_DEPRECATED_EXPORT QUICKCHARTS_EXPORT
#  define QUICKCHARTS_DEPRECATED_NO_EXPORT QUICKCHARTS_NO_EXPORT
#elif defined(QUICKCHARTS_NO_DEPRECATED_WARNINGS)
#  define QUICKCHARTS_DEPRECATED
#  define QUICKCHARTS_DEPRECATED_EXPORT QUICKCHARTS_EXPORT
#  define QUICKCHARTS_DEPRECATED_NO_EXPORT QUICKCHARTS_NO_EXPORT
#else
#  define QUICKCHARTS_DEPRECATED QUICKCHARTS_DECL_DEPRECATED
#  define QUICKCHARTS_DEPRECATED_EXPORT QUICKCHARTS_DECL_DEPRECATED_EXPORT
#  define QUICKCHARTS_DEPRECATED_NO_EXPORT QUICKCHARTS_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define QUICKCHARTS_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define QUICKCHARTS_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef QUICKCHARTS_NO_DEPRECATED
#  define QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0x61600
#endif
#ifdef QUICKCHARTS_NO_DEPRECATED_WARNINGS
#  define QUICKCHARTS_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef QUICKCHARTS_DEPRECATED_WARNINGS_SINCE
#  ifdef QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define QUICKCHARTS_DEPRECATED_WARNINGS_SINCE QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define QUICKCHARTS_DEPRECATED_WARNINGS_SINCE 0x61600
#  endif
#endif

#ifndef QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef QUICKCHARTS_DEPRECATED
#  define QUICKCHARTS_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > QUICKCHARTS_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define QUICKCHARTS_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* QUICKCHARTS_EXPORT_H */
