
#ifndef KNEWSTUFFQUICK_EXPORT_H
#define KNEWSTUFFQUICK_EXPORT_H

#ifdef KNEWSTUFFQUICK_STATIC_DEFINE
#  define KNEWSTUFFQUICK_EXPORT
#  define KNEWSTUFFQUICK_NO_EXPORT
#else
#  ifndef KNEWSTUFFQUICK_EXPORT
#    ifdef newstuffqmlplugin_EXPORTS
        /* We are building this library */
#      define KNEWSTUFFQUICK_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KNEWSTUFFQUICK_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KNEWSTUFFQUICK_NO_EXPORT
#    define KNEWSTUFFQUICK_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KNEWSTUFFQUICK_DECL_DEPRECATED
#  define KNEWSTUFFQUICK_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KNEWSTUFFQUICK_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFFQUICK_DECL_DEPRECATED_EXPORT KNEWSTUFFQUICK_EXPORT KNEWSTUFFQUICK_DECL_DEPRECATED
#endif

#ifndef KNEWSTUFFQUICK_DECL_DEPRECATED_NO_EXPORT
#  define KNEWSTUFFQUICK_DECL_DEPRECATED_NO_EXPORT KNEWSTUFFQUICK_NO_EXPORT KNEWSTUFFQUICK_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KNEWSTUFFQUICK_NO_DEPRECATED
#    define KNEWSTUFFQUICK_NO_DEPRECATED
#  endif
#endif

#define KNEWSTUFFQUICK_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KNEWSTUFFQUICK_NO_DEPRECATED) && !defined(KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KNEWSTUFFQUICK_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KNEWSTUFFQUICK_NO_DEPRECATED_WARNINGS) && !defined(KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KNEWSTUFFQUICK_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KNEWSTUFFQUICK_NO_DEPRECATED)
#  undef KNEWSTUFFQUICK_DEPRECATED
#  define KNEWSTUFFQUICK_DEPRECATED_EXPORT KNEWSTUFFQUICK_EXPORT
#  define KNEWSTUFFQUICK_DEPRECATED_NO_EXPORT KNEWSTUFFQUICK_NO_EXPORT
#elif defined(KNEWSTUFFQUICK_NO_DEPRECATED_WARNINGS)
#  define KNEWSTUFFQUICK_DEPRECATED
#  define KNEWSTUFFQUICK_DEPRECATED_EXPORT KNEWSTUFFQUICK_EXPORT
#  define KNEWSTUFFQUICK_DEPRECATED_NO_EXPORT KNEWSTUFFQUICK_NO_EXPORT
#else
#  define KNEWSTUFFQUICK_DEPRECATED KNEWSTUFFQUICK_DECL_DEPRECATED
#  define KNEWSTUFFQUICK_DEPRECATED_EXPORT KNEWSTUFFQUICK_DECL_DEPRECATED_EXPORT
#  define KNEWSTUFFQUICK_DEPRECATED_NO_EXPORT KNEWSTUFFQUICK_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KNEWSTUFFQUICK_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KNEWSTUFFQUICK_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KNEWSTUFFQUICK_NO_DEPRECATED
#  define KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT 0x57400
#endif
#ifdef KNEWSTUFFQUICK_NO_DEPRECATED_WARNINGS
#  define KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE
#  ifdef KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE 0x57400
#  endif
#endif

#ifndef KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KNEWSTUFFQUICK_DEPRECATED
#  define KNEWSTUFFQUICK_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KNEWSTUFFQUICK_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KNEWSTUFFQUICK_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#if KNEWSTUFFQUICK_DEPRECATED_WARNINGS_SINCE >= 0x55100
#  define KNEWSTUFFQUICK_DEPRECATED_VERSION_5_81(text) KNEWSTUFFQUICK_DECL_DEPRECATED_TEXT(text)
#else
#  define KNEWSTUFFQUICK_DEPRECATED_VERSION_5_81(text)
#endif
#define KNEWSTUFFQUICK_DEPRECATED_VERSION_5(minor, text)      KNEWSTUFFQUICK_DEPRECATED_VERSION_5_##minor(text)
#define KNEWSTUFFQUICK_DEPRECATED_VERSION(major, minor, text) KNEWSTUFFQUICK_DEPRECATED_VERSION_##major(minor, "Since "#major"."#minor". " text)
#define KNEWSTUFFQUICK_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KNEWSTUFFQUICK_DEPRECATED_VERSION_##major(minor, "Since "#textmajor"."#textminor". " text)
#if defined(__cpp_enumerator_attributes) && __cpp_enumerator_attributes >= 201411
#  define KNEWSTUFFQUICK_ENUMERATOR_DEPRECATED_VERSION(major, minor, text) KNEWSTUFFQUICK_DEPRECATED_VERSION(major, minor, text)
#  define KNEWSTUFFQUICK_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text) KNEWSTUFFQUICK_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#else
#  define KNEWSTUFFQUICK_ENUMERATOR_DEPRECATED_VERSION(major, minor, text)
#  define KNEWSTUFFQUICK_ENUMERATOR_DEPRECATED_VERSION_BELATED(major, minor, textmajor, textminor, text)
#endif

#endif /* KNEWSTUFFQUICK_EXPORT_H */
