# _build_config.py.in is converted into _build_config.py during the meson build process.

from __future__ import annotations


def build_config() -> dict[str, str]:
    """
    Return a dictionary containing build configuration settings.

    All dictionary keys and values are strings, for example ``False`` is
    returned as ``"False"``.

        .. versionadded:: 1.1.0
    """
    return dict(
        # Python settings
        python_version="3.13",
        python_install_dir=r"/usr/lib/python3.13/site-packages/",
        python_path=r"/usr/bin/python3.13",

        # Package versions
        contourpy_version="1.3.3",
        meson_version="1.9.1",
        mesonpy_version="0.18.0",
        pybind11_version="3.0.1",

        # Misc meson settings
        meson_backend="ninja",
        build_dir=r"/var/tmp/portage/dev-python/contourpy-1.3.3-r1/work/contourpy-1.3.3-python3_13/lib/contourpy/util",
        source_dir=r"/var/tmp/portage/dev-python/contourpy-1.3.3-r1/work/contourpy-1.3.3/lib/contourpy/util",
        cross_build="False",

        # Build options
        build_options=r"-Dbuildtype=plain -Db_ndebug=if-release -Db_vscrt=md -Db_lto=true -Db_pch=false -Dwerror=false -Dprefix=/usr -Dlibdir=lib64 -Dlocalstatedir=/var/lib -Dsysconfdir=/etc -Dwrap_mode=nodownload -Dvsenv=True -Dbuild.pkg_config_path=/var/tmp/portage/dev-python/contourpy-1.3.3-r1/temp/python3.13/pkgconfig:/usr/share/pkgconfig -Dpkg_config_path=/var/tmp/portage/dev-python/contourpy-1.3.3-r1/temp/python3.13/pkgconfig:/usr/share/pkgconfig --native-file=/var/tmp/portage/dev-python/contourpy-1.3.3-r1/temp/meson.x86_64-pc-linux-gnu.amd64.ini --native-file=/var/tmp/portage/dev-python/contourpy-1.3.3-r1/work/contourpy-1.3.3-python3_13/meson-python-native-file.ini",
        buildtype="plain",
        cpp_std="c++17",
        debug="False",
        optimization="plain",
        vsenv="True",
        b_ndebug="if-release",
        b_vscrt="from_buildtype",

        # C++ compiler
        compiler_name="gcc",
        compiler_version="14.3.1",
        linker_id="ld.bfd",
        compile_command="x86_64-pc-linux-gnu-g++",

        # Host machine
        host_cpu="x86_64",
        host_cpu_family="x86_64",
        host_cpu_endian="little",
        host_cpu_system="linux",

        # Build machine, same as host machine if not a cross_build
        build_cpu="x86_64",
        build_cpu_family="x86_64",
        build_cpu_endian="little",
        build_cpu_system="linux",
    )
